# 画面設計書 5-Pkgモード（pkg>）

## 概要

Juliaパッケージマネージャ（Pkg）のコマンドを実行するREPLモードの設計書。Pkg読み込み前はダミーモードが表示され、初回実行時にPkg.jlが遅延ロードされる。

### 本画面の処理概要

本画面は、Julia REPLのPkgモードであり、パッケージの追加・削除・更新・環境管理等のパッケージ管理操作を専用のコマンドインタフェースで実行する。

**業務上の目的・背景**：Juliaのパッケージ管理をREPLから効率的に行うためのモードである。`Pkg.add()`, `Pkg.rm()` 等の関数呼び出しの代わりに、簡潔なコマンド構文（`add PackageName`, `rm PackageName` 等）でパッケージ操作が可能である。Pkg.jlは大きなモジュールであるため、起動時間の短縮のために遅延ロード方式を採用している。初回アクセス時にダミーモードからPkg本体モードへの自動切り替えが行われる。プロンプトには現在のプロジェクト環境名が表示される。

**画面へのアクセス方法**：Juliaプロンプト画面で `]` キーを行頭で入力すると本モードに遷移する。プロンプトが `(EnvName) pkg>` のように、現在のプロジェクト環境名付きで変わり、パッケージ管理コマンドの入力が可能になる。

**主要な操作・処理内容**：
1. ユーザーがPkgモードのプロンプトにパッケージ管理コマンドを入力する
2. 初回実行時、`load_pkg()` により `Pkg.jl` が遅延ロードされる
3. Pkgモジュールのロード完了後、ダミーモードからPkg本体のREPL拡張モードに自動切り替えされる
4. パッケージの追加（add）、削除（rm）、更新（update）、解決（resolve）、インスタンス化（instantiate）等のコマンドが実行される
5. プロンプトは `Pkg_promptf()` により動的に生成され、現在のプロジェクト名が表示される

**画面遷移**：
- 遷移元：Juliaプロンプト（`]` キー入力、行頭）
- 遷移先：Juliaプロンプト（`Backspace` 行頭、`Ctrl+C`）
- sticky=trueにより、コマンド実行後もPkgモードが維持される

**権限による表示制御**：権限による表示制御は存在しない。ただし、プロジェクト環境に応じてプロンプトのプレフィックスが変わる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 123 | Pkg | 主機能 | Pkg.jlのadd/rm/update/resolve/instantiate等のパッケージ管理コマンド実行 |
| 102 | REPL | 補助機能 | REPLモジュール内のPkgモードプロンプトとして実装 |
| 60 | パッケージ読み込み | 補助機能 | require/importによるPkg.jlモジュールの遅延読み込み。初回アクセス時に自動ロード |
| 120 | Artifacts | 補助機能 | パッケージのバイナリアーティファクト管理にArtifactsシステムを使用 |
| 105 | TOML | 補助機能 | Project.toml/Manifest.tomlの読み書きにTOMLパーサーを使用 |

## 画面種別

コマンド実行（パッケージ管理モード）

## URL/ルーティング

該当なし（ターミナルベースのCLIアプリケーション）

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|-----|------|
| Pkgコマンド | 入力 | String | パッケージ管理コマンド文字列（add, rm, update等） |
| コマンド結果 | 出力 | String | パッケージ操作の結果メッセージ |
| プロンプト | 出力 | String | `(EnvName) pkg> ` 形式の動的プロンプト |

## 表示項目

| 項目名 | 表示内容 | 条件 |
|--------|----------|------|
| プロンプト | `(プロジェクト名) pkg> ` | プロジェクトファイルが存在する場合 |
| プロンプト（環境なし） | `pkg> ` | プロジェクトファイルが存在しない場合 |
| コマンド結果 | パッケージ操作の結果メッセージ | コマンド実行後 |
| ロード中メッセージ | Pkg.jlのロード中であることを示す表示 | 初回アクセス時 |

## イベント仕様

### 1-コマンド実行（Enter）

ユーザーがPkgコマンドを入力してEnterを押下する。ダミーモード時は `on_enter` コールバックが `load_pkg()` を呼び出してPkg.jlをロードし、本体のPkgモードに自動遷移する。Pkgモード本体ではPkg.jlのREPL拡張がコマンドを処理する。

### 2-ダミーモードからの自動切替

初回のEnter押下時に以下の処理が行われる：
1. `load_pkg()` が `Base.require_stdlib(Pkg_pkgid, "REPLExt", REPL)` を呼び出す
2. Pkg.jlがロードされると `REPLExt` が `PkgCompletionProvider` を含むモードを登録する
3. `repl.interface.modes` から `PkgCompletionProvider` を持つモードを検索する
4. 見つかったモードに入力バッファを移行して遷移する

### 3-モード離脱（Backspace / Ctrl+C）

行頭で `Backspace` を押下するか、`Ctrl+C` を押下するとJuliaプロンプトに戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象ファイル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| add コマンド | Project.toml, Manifest.toml | UPDATE | パッケージ依存の追加 |
| rm コマンド | Project.toml, Manifest.toml | UPDATE | パッケージ依存の削除 |
| update コマンド | Manifest.toml | UPDATE | パッケージバージョンの更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| - | 情報 | パッケージ操作の結果メッセージ | コマンド実行成功時 |
| - | エラー | パッケージ解決エラー等のエラーメッセージ | コマンド実行失敗時 |

## 例外処理

| 例外 | 発生条件 | 対応 |
|------|----------|------|
| Pkg.jlロード失敗 | Pkg.jlが見つからない・ロードエラー | エラーメッセージを表示してJuliaプロンプトに戻る |
| パッケージ解決エラー | 依存関係の解決に失敗 | Pkgのエラーハンドリングによりエラーメッセージを表示 |
| ネットワークエラー | パッケージレジストリへのアクセス失敗 | タイムアウトまたは接続エラーメッセージを表示 |

## 備考

- プロンプト生成関数 `Pkg_promptf()` は `Pkg_beforeload.jl` で定義される
- プロジェクト名はProject.tomlの `name` フィールドから取得される。30文字を超える場合は27文字+`...` に切り詰められる
- ベースプロジェクトとサブプロジェクトの場合、パスプレフィックスが追加される（例: `(Root/sub) pkg>`）
- `Pkg_pkgid` は `Base.PkgId(Base.UUID("44cfe95a-1eb2-52ea-b672-e2afdf69b78f"), "Pkg")` として定義される
- `sticky=true` が設定されているため、コマンド実行後もPkgモードが維持される
- ダミーモードでは `EmptyCompletionProvider` が使用され、補完は提供されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Pkgモードのデータ構造はダミーモードのPromptと動的プロンプト生成関数が中心である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pkg_beforeload.jl | `stdlib/REPL/src/Pkg_beforeload.jl` | Pkg_pkgid定数（5行目）、load_pkg()関数（6行目）、Pkg_promptf()関数（93-122行） |
| 1-2 | Pkg_beforeload.jl | `stdlib/REPL/src/Pkg_beforeload.jl` | find_project_file()（24-45行）、projname()（62-87行）: プロジェクト名解決ロジック |

**読解のコツ**: `Pkg_beforeload.jl` はPkg.jlがロードされる前に必要な機能を提供する。プロンプト生成やプロジェクト検出は、Pkg本体に依存せずに動作する必要があるため、ここに実装されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | REPL.jl | `stdlib/REPL/src/REPL.jl` | dummy_pkg_modeのPrompt設定（1334-1359行）: on_enterでload_pkg()と自動切り替えを確認 |
| 2-2 | REPL.jl | `stdlib/REPL/src/REPL.jl` | setup_interface()内のPkgモード統合（1366-1391行）: 履歴プロバイダーへの登録 |

**主要処理フロー**:
1. **1334-1339行**: ダミーPkgモードのPrompt設定（Pkg_promptf、EmptyCompletionProvider）
2. **1341-1358行**: on_enterコールバック: load_pkg()でPkgロード → PkgCompletionProviderモードを検索 → 遷移
3. **1369行**: 履歴プロバイダーにpkgモードを登録

#### Step 3: プロンプト生成の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Pkg_beforeload.jl | `stdlib/REPL/src/Pkg_beforeload.jl` | Pkg_promptf()関数（93-122行）: プロジェクト名の解決とプロンプト文字列の生成 |

### プログラム呼び出し階層図

```
setup_interface() で dummy_pkg_mode を設定 [1334行]
    |
    +-- Pkg_promptf()                    [93行]
    |       +-- find_project_file()       [24行]
    |       +-- projname()                [62行]
    |       +-- find_root_base_project()  [47行]
    |
    +-- on_enter (初回コマンド実行時)     [1341行]
            |
            +-- load_pkg()               [6行]
            |       +-- Base.require_stdlib(Pkg_pkgid, "REPLExt", REPL)
            |
            +-- PkgCompletionProvider モードを検索
            +-- transition(s, mode)
```

### データフロー図

```
[入力]                  [処理]                         [出力]

]キー入力        -----> ダミーPkgモード起動       -----> (EnvName) pkg> プロンプト
                        |
ユーザーコマンド -----> on_enter
                        |
                  load_pkg()
                        |
                  REPLExt ロード
                        |
                  PkgCompletionProvider
                  モードに遷移
                        |
                  Pkg コマンド実行        -----> 操作結果表示
                        |
                  Project.toml /
                  Manifest.toml 更新      -----> ファイル更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| REPL.jl | `stdlib/REPL/src/REPL.jl` | ソース | ダミーPkgモードのPrompt設定（1334-1359行） |
| Pkg_beforeload.jl | `stdlib/REPL/src/Pkg_beforeload.jl` | ソース | Pkgロード前の機能。Pkg_promptf(), load_pkg(), find_project_file() |
| LineEdit.jl | `stdlib/REPL/src/LineEdit.jl` | ソース | モード遷移とキーマップ |
| Pkg.jl | `stdlib/Pkg/` | ソース | パッケージマネージャ本体（遅延ロード） |
